/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.traceroute.agent;

import ibm.nways.jdm.AdaptedRemoteWatcher;
import ibm.nways.jdm.RemoteWatchable;
import ibm.nways.jdm.RemoteWatcherAdapter;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.traceroute.ITraceRouteServer;
import ibm.nways.jdm.traceroute.Path;
import ibm.nways.jdm.traceroute.StatusEvent;
import ibm.nways.jdm.traceroute.StatusListener;
import ibm.nways.jdm.traceroute.TraceRouteOptions;
import ibm.nways.jdm.traceroute.TraceRouteServerFinishedEvent;
import ibm.nways.jdm.traceroute.agent.ITraceRouteAgent;
import ibm.nways.jdm.traceroute.agent.ITraceRouteAgentHandler;
import ibm.nways.jdm.traceroute.voyager.MobilityException;
import ibm.nways.jdm.traceroute.voyager.OneWay;
import ibm.nways.jdm.traceroute.voyager.Proxy;
import java.io.Serializable;
import java.rmi.Naming;
import java.rmi.RemoteException;

public class TraceRouteAgent
implements ITraceRouteAgent,
Serializable,
AdaptedRemoteWatcher {
    protected ITraceRouteAgentHandler home;
    protected StatusListener statusListener;
    protected TraceRouteOptions options;
    protected IPAddress srcIP;
    protected IPAddress destIP;
    protected Path path;
    private static final boolean debug = false;
    protected ITraceRouteServer server;

    public void performTask() throws MobilityException {
        this.atDest();
    }

    public void atDest() throws MobilityException {
        try {
            String string = String.valueOf(this.options.voyagerAddress) + "/" + "TraceRouteServer";
            ITraceRouteServer iTraceRouteServer = (ITraceRouteServer)Naming.lookup(string);
            RemoteWatcherAdapter remoteWatcherAdapter = new RemoteWatcherAdapter(this);
            this.server = iTraceRouteServer.traceRoute(this.srcIP, this.destIP, this.options, remoteWatcherAdapter);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MobilityException(exception.getMessage());
        }
    }

    public void atHome(ITraceRouteAgentHandler iTraceRouteAgentHandler) {
        iTraceRouteAgentHandler.handleTraceRouteAgent(this);
        this.stopWorking();
    }

    public synchronized void stopWorking() {
        try {
            this.server.stopWorking();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void update(RemoteWatchable remoteWatchable, Object object) {
        if (object instanceof TraceRouteServerFinishedEvent) {
            this.path = ((TraceRouteServerFinishedEvent)object).getPath();
            this.home.handleTraceRouteAgent(this);
            return;
        }
        if (object instanceof StatusEvent) {
            this.statusListener.statusEventOccurred((StatusEvent)object);
            return;
        }
        System.out.println(object);
    }

    public boolean wantsStatusMessages() {
        return this.statusListener != null;
    }

    public void setStatusListener(StatusListener statusListener) {
        this.statusListener = statusListener;
    }

    public StatusListener getStatusListener() {
        return this.statusListener;
    }

    public ITraceRouteAgentHandler getHome() {
        return this.home;
    }

    public IPAddress getSrcIpAddress() {
        return this.srcIP;
    }

    public IPAddress getDestIpAddress() {
        return this.destIP;
    }

    public TraceRouteOptions getOptions() {
        return this.options;
    }

    public Path getPath() {
        return this.path;
    }

    public void setHome(ITraceRouteAgentHandler iTraceRouteAgentHandler) {
        this.home = Proxy.of(iTraceRouteAgentHandler);
    }

    public void setSrcIpAddress(IPAddress iPAddress) {
        this.srcIP = iPAddress;
    }

    public void setDestIpAddress(IPAddress iPAddress) {
        this.destIP = iPAddress;
    }

    public void setOptions(TraceRouteOptions traceRouteOptions) {
        this.options = traceRouteOptions;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    private class PathListener
    implements StatusListener {
        private StatusListener statusListener;

        public PathListener(Path path, ITraceRouteAgent iTraceRouteAgent) {
            TraceRouteAgent.this = TraceRouteAgent.this;
            path.addStatusListener(this);
            this.statusListener = iTraceRouteAgent.getStatusListener();
        }

        public void statusEventOccurred(StatusEvent statusEvent) {
            try {
                Object[] objectArray = new Object[]{statusEvent};
                OneWay.invoke(this.statusListener, "statusEventOccurred", objectArray);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.err.println("TraceRouteServer.PathListener.statusEventOccurred");
                System.err.println(noSuchMethodException);
                return;
            }
        }
    }
}

